#include "stdafx.h"
#include "global.h"
#include "AutoTest.h"
#include "CExposureGainPropertyPage.h"

CExposureGainPropertyPage::CExposureGainPropertyPage()
	: CPropertyPage(IDD_PROPERTY_EXPOSURE_GAIN)
{
}

void CExposureGainPropertyPage::OnAutoExposure()
{
	if (GetDlgItem(IDC_SLIDER_EXPOSURE))
	{
		unsigned time = 0;
		Explorecam_get_ExpoTime(g_hCam, &time);
		SetExpoTimeValue(time);
	}

	if (GetDlgItem(IDC_SLIDER_GAIN))
	{
		unsigned short gain = 0;
		Explorecam_get_ExpoAGain(g_hCam, &gain);
		SetGainValue(gain);
	}
}

void CExposureGainPropertyPage::UpdateSlidersEnable()
{
	int bAutoExp = 0;
	Explorecam_get_AutoExpoEnable(g_hCam, &bAutoExp);
	GetDlgItem(IDC_SLIDER_TARGET)->EnableWindow(bAutoExp);
	GetDlgItem(IDC_SLIDER_EXPOSURE)->EnableWindow(!bAutoExp);
	GetDlgItem(IDC_SLIDER_GAIN)->EnableWindow(!bAutoExp);

	((CSliderCtrl*)GetDlgItem(IDC_SLIDER_TARGET))->SetRange(EXPLORE_AETARGET_MIN, EXPLORE_AETARGET_MAX);
	unsigned short target = 0;
	Explorecam_get_AutoExpoTarget(g_hCam, &target);
	SetTargetValue(target);

	unsigned timeMin = 0, timeMax = 0, timeDef = 0, timeVal = 0;
	Explorecam_get_ExpTimeRange(g_hCam, &timeMin, &timeMax, &timeDef);
	((CSliderCtrl*)GetDlgItem(IDC_SLIDER_EXPOSURE))->SetRange(timeMin, timeMax);
	Explorecam_get_ExpoTime(g_hCam, &timeVal);
	SetExpoTimeValue(timeVal);

	unsigned short gainMin = 0, gainMax = 0, gainDef = 0, gainVal = 0;
	Explorecam_get_ExpoAGainRange(g_hCam, &gainMin, &gainMax, &gainDef);
	((CSliderCtrl*)GetDlgItem(IDC_SLIDER_GAIN))->SetRange(gainMin, gainMax);
	Explorecam_get_ExpoAGain(g_hCam, &gainVal);
	SetGainValue(gainVal);
}

void CExposureGainPropertyPage::SetTargetValue(int value)
{
	((CSliderCtrl*)GetDlgItem(IDC_SLIDER_TARGET))->SetPos(value);
	SetDlgItemInt(IDC_STATIC_TARGET, value);
}

void CExposureGainPropertyPage::SetExpoTimeValue(unsigned value)
{
	((CSliderCtrl*)GetDlgItem(IDC_SLIDER_EXPOSURE))->SetPos(value);
	CString str;
	str.Format(_T("%d us"), value);
	SetDlgItemText(IDC_STATIC_EXPOSURE, str);
}

void CExposureGainPropertyPage::SetGainValue(int value)
{
	((CSliderCtrl*)GetDlgItem(IDC_SLIDER_GAIN))->SetPos(value);
	SetDlgItemInt(IDC_STATIC_GAIN, value);
}

BEGIN_MESSAGE_MAP(CExposureGainPropertyPage, CPropertyPage)
	ON_BN_CLICKED(IDC_CHECK_AUTO, &CExposureGainPropertyPage::OnBnClickedCheckAuto)
	ON_WM_HSCROLL()
END_MESSAGE_MAP()

void CExposureGainPropertyPage::OnBnClickedCheckAuto()
{
	Explorecam_put_AutoExpoEnable(g_hCam, ((CButton*)GetDlgItem(IDC_CHECK_AUTO))->GetCheck() ? 1 : 0);
	UpdateSlidersEnable();
}

BOOL CExposureGainPropertyPage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	int bAutoExp = 0;
	Explorecam_get_AutoExpoEnable(g_hCam, &bAutoExp);
	((CButton*)GetDlgItem(IDC_CHECK_AUTO))->SetCheck(bAutoExp);
	UpdateSlidersEnable();

	return TRUE;  
}

void CExposureGainPropertyPage::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	if (pScrollBar == GetDlgItem(IDC_SLIDER_TARGET))
	{
		unsigned short curTarget = 0;
		Explorecam_get_AutoExpoTarget(g_hCam, &curTarget);
		unsigned short target = ((CSliderCtrl*)GetDlgItem(IDC_SLIDER_TARGET))->GetPos();
		if (target != curTarget)
		{
			Explorecam_put_AutoExpoTarget(g_hCam, target);
			SetDlgItemInt(IDC_STATIC_TARGET, target);
		}
	}
	else if (pScrollBar == GetDlgItem(IDC_SLIDER_EXPOSURE))
	{
		unsigned curTime = 0;
		Explorecam_get_ExpoTime(g_hCam, &curTime);
		unsigned time = ((CSliderCtrl*)GetDlgItem(IDC_SLIDER_EXPOSURE))->GetPos();
		if (time != curTime)
		{
			Explorecam_put_ExpoTime(g_hCam, time);
			CString str;
			str.Format(_T("%d us"), time);
			SetDlgItemText(IDC_STATIC_EXPOSURE, str);
		}
	}
	else if (pScrollBar == GetDlgItem(IDC_SLIDER_GAIN))
	{
		unsigned short curGain = 0;
		Explorecam_get_ExpoAGain(g_hCam, &curGain);
		unsigned short gain = ((CSliderCtrl*)GetDlgItem(IDC_SLIDER_GAIN))->GetPos();
		if (gain != curGain)
		{
			Explorecam_put_ExpoAGain(g_hCam, gain);
			SetDlgItemInt(IDC_STATIC_GAIN, gain);
		}
	}

	CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);
}
