#include "stdafx.h"
#include "global.h"
#include "AutoTest.h"
#include "CSnapTestPropertyPage.h"

CSnapTestPropertyPage::CSnapTestPropertyPage()
	: CPropertyPage(IDD_PROPERTY_SNAP_TEST)
	, m_bStarting(false), m_totalCount(0), m_count(0), m_snap(0)
{
}

void CSnapTestPropertyPage::UpdateHint()
{
	CString str;
	str.Format(_T("%d/%d"), m_count, m_totalCount);
	SetDlgItemText(IDC_STATIC_INFO, str);
}

BEGIN_MESSAGE_MAP(CSnapTestPropertyPage, CPropertyPage)
	ON_EN_CHANGE(IDC_EDIT_SNAP_COUNT, &CSnapTestPropertyPage::OnEnChangeEditSnapCount)
	ON_BN_CLICKED(IDC_BUTTON_SNAP_START, &CSnapTestPropertyPage::OnBnClickedButtonStart)
	ON_WM_TIMER()
END_MESSAGE_MAP()

void CSnapTestPropertyPage::OnEnChangeEditSnapCount()
{
	m_totalCount = GetDlgItemInt(IDC_EDIT_SNAP_COUNT);
	UpdateHint();
	GetDlgItem(IDC_BUTTON_SNAP_START)->EnableWindow(m_totalCount > 0);
}

void CSnapTestPropertyPage::OnTimer(UINT_PTR nIDEvent)
{
	if (g_bSnapFinished)
		return;

	g_bSnapFinished = false;
	g_snapCount = m_count;
	Explorecam_Snap(g_hCam, m_snap);

	if (m_snap + 1 < Explorecam_get_StillResolutionNumber(g_hCam))
		++m_snap;
	else
	{
		m_snap = 0;
		++m_count;
		UpdateHint();
		if (m_count >= m_totalCount)
		{
			Stop();
			AfxMessageBox(_T("Snap test completed."));
		}
	}
}

void CSnapTestPropertyPage::Stop()
{
	KillTimer(1);
	g_bSnapTesting = m_bStarting = false;
	SetDlgItemText(IDC_BUTTON_SNAP_START, _T("Start"));
	GetDlgItem(IDC_EDIT_SNAP_COUNT)->EnableWindow(TRUE);
}

void CSnapTestPropertyPage::OnBnClickedButtonStart()
{
	if (m_bStarting)
		Stop();
	else
	{
		g_snapDir = GetAppTimeDir(_T("SnapTest"));
		if (!PathIsDirectory(g_snapDir))
			SHCreateDirectory(m_hWnd, (LPCTSTR)g_snapDir);

		g_bSnapTesting = m_bStarting = true;
		g_bCheckBlack = false;
		m_count = m_snap = 0;
		SetDlgItemText(IDC_BUTTON_SNAP_START, _T("Stop"));
		GetDlgItem(IDC_EDIT_SNAP_COUNT)->EnableWindow(FALSE);
		SetTimer(1, 500, nullptr);
	}
}

BOOL CSnapTestPropertyPage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	UpdateHint();
	GetDlgItem(IDC_BUTTON_SNAP_START)->EnableWindow(FALSE);

	return TRUE;
}
